%--------------------------------------------------------------------
% Author: Mamata Naik, Amit Pujari
% Date Completed:  19/06/2007
% Department of Bioengineering, University of Strathclyde
%------------------------------------------------------------------------------------------------------------------------------------------------------
% The objective of this code is to comapare the original image with the
% segemented image to calculate the number of correctly and incorrectly segmented pixels
% and express their value in terms of percentage.
%-------------------------------------------------------------------------------------------------------------------------------------------------------
%  The program consists of the following steps
%  1. Load the original image 
%  2. Convert the original image into double for computations
%  3. Load the segmented image to be compared
%  4. Assign different labels to different regions of interest in the input image (original image) and count the total number of labelled pixels in
%     that specific region
%  5. Label the segmented image
%  6. Compare the original image(labelled region) to the labelled region of segmented image
%  7. Disregard the pixel if it does not match the two labels
%  8. Count number of correctly and incorrectly segmented pixels
%  9. Express value of correctly and incorrectly segmented pixels in terms of percentage
%------------------------------------------------------------------------------------------------------------------------------------------------------
th1=35;
th2=55;

in_im1 = imread('C:\Documents and Settings\Subbu\Desktop\brain_mri_transversal_t1_002.jpg');        % Load original input image
newimag = rgb2gray(in_im1);                                                                         % Convert the RGB image to grey
newimag = double(newimag);                                                                          % Convert to double for calculations

in_im2=imread('C:\Documents and Settings\Subbu\Desktop\aaa.jpg');                                   % Read the segmented image into Matlab
L = bwlabeln(in_im2);                                                                               %Using the black and white labelling,

imshow(L);
[y,x,p] = impixel;                                                                            %Once the cluster has been labelled the user must 
                                                                                              %click on a region to count number of pixels 
                                                                              

labelnum = p(1);       
                                                                                              %The label associated with specific region selected
                                                                                                
                                                                                                
totsize = size(in_im1);                                                                                                                                
xsize = totsize(1);
ysize = totsize(2);

for looper1 = 1:xsize
     for looper2 = 1:ysize
         if(in_im1(xsize,ysize)>=th1)
             if(in_im1(xsize,ysize)<=th2)
         if L(looper1,looper2) ~= labelnum  
                                                                                            %Compares the original image to the labelled region           
           in_im1(looper1,looper2) = 0;   
             
                                                                                            %disgards the pixel if it does not match the label number
       end
     end
         end
     end
end
 
 in_im1 = uint8(in_im1 - 1);                                                              %converts a double to a single for image viewing
 imshow(in_im1);                                                                          
 
 
    
ab=numel(find(in_im2));                                                         % Find the number of correctly segmented pixels
pctwpix= (ab/(numel(in_im2)))*100; 
                                                                                % Calculate the the percentage of correctly segmented pixels
imagesc(newimag);
axis image
 
ab=numel(find(in_im2)); 
pctwpix=round(1000*ab/numel(in_im2))/10; 
cd= (98-pctwpix);
incorrect_pixels=cd;                                                           %display incorrectly segmented pixels
display(incorrect_pixels);
title([int2str(ab) ... 
' correct pixels (' ...                                                        %display correctly segmented pixels  
num2str(pctwpix) '%)']);
